/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class FileControl {
    private static final String TRACE_MASKT = "XDFCQFPT";
    private static final String TRACE_MASKD = "XDFCQFPD";
    private static final String TRACE_MASKF = "XDFCQFPF";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "DFCQryPath");
    private static final short ERRID_0410 = 1040;
    private static final short ERRID_0411 = 1041;
    private static final short ERRID_0412 = 1042;
    private static final short ERRID_0413 = 1043;
    private static final short ERRID_0414 = 1044;
    private static final short ERRID_0415 = 1045;
    private static final String DOT = ".";
    private static final String CHANGE_DOT = "\\.";
    private static final String QUESTION = "?";
    private static final String CHANGE_QUESTION = ".";
    private static final String ASTER = "*";
    private static final String CHANGE_ASTER = ".*";
    private static final boolean debug = false;

    public static void readDefFile(String defFn, ArrayList dfcMask, ArrayList dfcPath) throws FileNotFoundException, Throwable {
        String str;
        BufferedReader in;
        try {
            Trace.trace(TRACE_MASKF, "DFC query file path trm file = [" + defFn + "]");
            in = new BufferedReader(new FileReader(defFn));
        }
        catch (FileNotFoundException fnfe) {
            HException hexc = new HException(fnfe);
            new FrameworkLog(_logInfo, 1040, hexc).log();
            throw hexc;
        }
        catch (Throwable e) {
            HException hexc = new HException(e);
            new FrameworkLog(_logInfo, 1041, e).log();
            throw e;
        }
        int index = 0;
        while ((str = in.readLine()) != null) {
            if (str.length() == 0) {
                Trace.trace(TRACE_MASKF, "Len of a line from DFCFilePathTrmFile is 0");
                continue;
            }
            if (str.substring(0, 1).equals("#")) continue;
            index = (str = str.trim()).indexOf(32);
            if (index == -1) {
                in.close();
                Trace.trace(TRACE_MASKF, "DFC qry path file = [" + defFn + "] has an error");
                Trace.trace(TRACE_MASKF, "DFC qry path data in error =[" + str + "]");
                HException hexc = new HException("DFC qry path file=[" + defFn + "]. Its contents has an error. Error line=[" + str + "]");
                new FrameworkLog(_logInfo, 1042, hexc).log(FrameworkLogAttributes.INFO_LOG);
                throw hexc;
            }
            String mask = str.substring(0, index).trim();
            StringBuffer strBuffer = FileControl.convertString(mask, ".", CHANGE_DOT);
            strBuffer = FileControl.convertString(strBuffer.toString(), QUESTION, ".");
            strBuffer = FileControl.convertString(strBuffer.toString(), ASTER, CHANGE_ASTER);
            Trace.trace(TRACE_MASKF, "Adding this:  orgMask=" + mask + " conMask=" + strBuffer.toString());
            dfcMask.add(strBuffer.toString());
            String path = str.substring(index).trim();
            index = path.indexOf(32);
            if (index != -1) {
                String extra = path.substring(index).toUpperCase();
                path = path.substring(0, index).trim();
                if (extra.indexOf(67) != -1) {
                    String dirPath = path.substring(0, 1).equals(ASTER) ? FileControl.useDefMask(defFn, path) : path;
                    Trace.trace(TRACE_MASKF, "Path =[" + dirPath + "] has directory creation enabled.");
                    File dir = new File(dirPath);
                    if (dir.exists()) {
                        Trace.trace(TRACE_MASKF, "Path =[" + dirPath + "] already exists.");
                    } else {
                        dir.mkdirs();
                        Trace.trace(TRACE_MASKF, "Path =[" + dirPath + "] has been created.");
                    }
                }
            }
            dfcPath.add(path);
        }
        in.close();
    }

    public static String getFilePath(String defFn, String fn, ArrayList dfcMask, ArrayList dfcPath) throws HException {
        String filePath = FileControl.searchForThePath(fn, dfcMask, dfcPath);
        if (filePath.length() == 0) {
            Trace.trace(TRACE_MASKF, "Error: No path found for the file =[" + fn + "].");
            HException hexc = new HException("No path found for the file =[" + fn + "]");
            new FrameworkLog(_logInfo, 1045, hexc).log();
            throw hexc;
        }
        if (filePath.substring(0, 1).equals(ASTER)) {
            filePath = FileControl.useDefMask(defFn, filePath);
        }
        Trace.trace(TRACE_MASKF, "This is the filePath=[" + filePath + "] for the file=[" + fn + "]");
        filePath = filePath.replace('/', File.separatorChar);
        return filePath;
    }

    private static String useDefMask(String defFn, String filePath) throws HException {
        int index = defFn.lastIndexOf("/");
        if (index == -1) {
            Trace.trace(TRACE_MASKF, "Error: No path specified for the DFC query path file =[" + defFn + "]");
            HException hexc = new HException("No path specified for the DFC query path file=[" + defFn + "]");
            new FrameworkLog(_logInfo, 1044, hexc).log();
            throw hexc;
        }
        filePath = filePath.length() > 1 && filePath.substring(1, 2).equals("/") ? defFn.substring(0, index) + filePath.substring(1) : defFn.substring(0, index + 1) + filePath.substring(1);
        return filePath;
    }

    protected static StringBuffer convertString(String str, String searchStrFor, String changeStrTo) {
        StringBuffer strBuffer = new StringBuffer(str.length() * 2);
        String token = "";
        StringTokenizer parser = new StringTokenizer(str, searchStrFor, true);
        while (parser.hasMoreTokens()) {
            token = parser.nextToken();
            if (token.equals(searchStrFor)) {
                strBuffer.append(changeStrTo);
                continue;
            }
            strBuffer.append(token);
        }
        return strBuffer;
    }

    protected static String searchForThePath(String tmpFn, ArrayList dfcMask, ArrayList dfcPath) {
        String tmpMask = null;
        String filePath = "";
        boolean foundPath = false;
        Trace.trace(TRACE_MASKF, "-> FileControl.searchForThePath()");
        Iterator iteratorFilePath = dfcPath.iterator();
        Iterator iteratorMask = dfcMask.iterator();
        while (iteratorMask.hasNext() && !foundPath) {
            tmpMask = (String)iteratorMask.next();
            filePath = (String)iteratorFilePath.next();
            foundPath = Pattern.matches(tmpMask, tmpFn);
        }
        if (foundPath) {
            Trace.trace(TRACE_MASKF, "After searching DFC qryPath: fn=[" + tmpFn + "] mask=[" + tmpMask + "] found=" + foundPath);
        } else {
            Trace.trace(TRACE_MASKF, "match for fn=[" + tmpFn + "]  not found");
        }
        Trace.trace(TRACE_MASKF, "<- FileControl.searchForThePath)_final foundPath=" + foundPath);
        if (foundPath) {
            return filePath;
        }
        return "";
    }
}

